

#---------------------------------------------------------------
# Análise das variáveis e dos objetos a serem agrupados
#---------------------------------------------------------------
#Atribuindo nomes às categorias 
fact <-data.frame(factbook[,2:11], row.names = factbook$GROCERY)

estrut <-data.frame(fact[,1:5])
promo <- data.frame(fact[6:10])


#Detecção de variáveis atípicas
# Calculando a distância de Mahalonobis 
f.cov <- var(scale(fact)) # standardize first
f.cov <- var(fact)
f.mean <- apply(fact,2,mean)
f.mah <- mahalanobis(fact, f.mean, f.cov)

#Detecção de variáveis atípicas: estrut
# Calculando a distância de Mahalonobis 
e.cov <- var(scale(estrut)) # standardize first
e.cov <- var(estrut)
e.mean <- apply(estrut,2,mean)
e.mah <- mahalanobis(estrut, e.mean, e.cov)

#Detecção de variáveis atípicas: promo
# Calculando a distância de Mahalonobis 
p.cov <- var(scale(promo)) # standardize first
p.cov <- var(promo)
p.mean <- apply(promo,2,mean)
p.mah <- mahalanobis(promo, p.mean, p.cov)

## Vemos o valor discrepante para a categoria CANNED_HA e EGGS do 
## do banco de dados promo
## Podemos remover usando:
remover <- c("CANNED_HA", "EGGS")
## Se tivermos mais variáveis para remover devemos separar cada um por 
## vírgula e colocar aspas em cada uma.
promo.r<-promo[!(row.names(promo) %in% remover), ]
## Como temos apenas uma variável, poderíamos entrar com ela diretamente
## no lugar de remover

#Analisando a variância
apply(promo.r, 2, var)

#Patronizando as variáveis qualitativas
promo.p<-scale(promo.r)

#---------------------------------------------------------------
# Seleção do critério de agrupamento
#---------------------------------------------------------------
#Calculando a distância Euclidiana
d.eucl <- dist(promo.p, method = "euclidean")

#Vizualizando a distância euclidiana para as quatro primeiras categorias:
round(as.matrix(d.eucl)[1:4, 1:4], 1)




#----------------------------------------------------------------
#Seleção do algoritmo de agrupamento
res.hc <- hclust(d = d.eucl, method = "ward.D2")


# Calculando a matriz cofenética
## Compara as distâncias efetivamente observadas entre os objetos e
## as distâncias previstas a partir do processo de agrupamento.
res.coph <- cophenetic(res.hc)
# Correlation between cophenetic distance and
# the original distance
cor(d.eucl, res.coph)


#Comparando com o método da ligação média
hc.m <- hclust(d.eucl, method = "average")
cor(d.eucl, cophenetic(hc.m))


#-----------------------------------------------------------------
#Definição do número de agrupamentos

library("factoextra")
fviz_dend(res.hc, cex = 0.5)

install.packages("NbClust")
library("NbClust")

#Podemos instalar mais de uma pacote por vez usando
pkgs <- c("factoextra", "NbClust")
install.packages(pkgs)

nb <- NbClust(promo.p, distance = "euclidean", min.nc = 2,
              max.nc = 10, method = "ward.D2", index = "all")

fviz_nbclust(nb)
#------------------------
#Para apenas o índice ccc 

nb.c <- NbClust(promo.p, distance = "euclidean", min.nc = 2,
              max.nc = 10, method = "ward.D2", index = "ccc")

fviz_nbclust(nb.c)
#-----------------------
#Para os índices 'ccc' e pseudo-f('ch')
nb.i <- NbClust(promo.p, distance = "euclidean", min.nc = 2,
                max.nc = 10, method = "ward.D2", index = c("ccc", "ch"))
fviz_nbclust(nb.i)

#-------------------------
#Obtendo os agrupamentos
g <- cutree(res.hc,k=4)
#Número de membros em cada agrupamento
table(g)
#Obtendo o nome dos membros no agrupamento 1
rownames(promo.p)[g == 1]
#Podemos vizualidar o resultado do agrupamento no dendograma
fviz_dend(res.hc, k = 4, # Cut in four groups
          cex = 0.5, # label size
          k_colors = c("#2E9FDF", "#00BB0C", "#E7B800", "#FC4E07"),
          color_labels_by_k = TRUE, # color labels by groups
          rect = TRUE # Add rectangle around groups
          )

#Calculado a média em cada grupo
# Utilizando uma função para em g cada grupo g em i
clust.centroid = function(i, dat, g) {
  ind = (g == i)
  colMeans(dat[ind,])
}
#
sapply(unique(g), clust.centroid, promo.p, g)
mat<- t(as.matrix(sapply(unique(g), clust.centroid, promo.p, g)))
#Obtendo a média dos valores originais (não padronizados) por grupo
sapply(unique(g), clust.centroid, promo.r, g)
round(sapply(unique(g), clust.centroid, promo.r, g), 1)

#-----------------------          --------------------------------
#Segundo estágio
#Análise se 4 é um número adequado
fviz_nbclust(promo.p, kmeans, method = "wss") +
  geom_vline(xintercept = 4, linetype = 2)

#Utilizando algoritmo de k-medias
#kmeans(x, centers, iter.max = 10, nstart = 1)
## Definindo uma semente. Isso permite que o resutlado seja 
## reproduzível, já que a semente interfere no resutlado final
set.seed(123)
km.res <- kmeans(promo.p, 4, nstart = 25)
print(km.res)

# Utilizando os valores médios das variáveis em cada grupo
## para o método de k-medias
mat<- t(as.matrix(sapply(unique(g), clust.centroid, promo.p, g)))

km.res2 <- kmeans(promo.p, mat, nstart = 25)

print(km.res2)

#-----------------------------------------------------------------
#Interpretação e validação dos agrupamentos
#--------------------------------------
#Acrescentando a coluna de clusters do k-media nos dados originais
promo.k <- cbind(promo.r, Grupos=km.res$cluster)


#Calculando a média dos grupos para os dados originais
aggregate(promo.r, by=list(cluster=km.res$cluster), mean)

aggregate(promo.r, by=list(cluster=km.res2$cluster), mean)
round(aggregate(promo.r, by=list(cluster=km.res2$cluster), mean),2)

#
fviz_cluster(km.res, data = promo.r,
             palette = c("#2E9FDF", "#00BB0C", "#E7B800", "#FC4E07"),
             ellipse.type = "euclid", # Concentration ellipse
             star.plot = TRUE, # Add segments from centroids to items
             repel = TRUE, # Avoid label overplotting (slow)
             ggtheme = theme_minimal()
            )


install.packages("cluster")

library(cluster)
clusplot(promo.p, km.res$cluster, main='Representação bidimensional do agrupamento',
         color=TRUE, shade=TRUE,
         labels=2, lines=0)
